<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('domain', 255)->nullable();
			$table->text('avatar')->nullable();
			$table->timestamps();
			$table->bigInteger('account_id')->nullable();
			$table->bigInteger('owner_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}