<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->timestamps();
			$table->string('uuid', 255)->nullable();
			$table->string('timezone', 255)->nullable();
			$table->string('domain', 255)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('address_2', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('zip')->nullable();
			$table->string('country', 255)->nullable();
			$table->bigInteger('industry_id')->nullable();
			$table->string('date_format', 255)->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}