<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('branch_name')->references('name')->on('branchs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('depositoris', function(Blueprint $table) {
			$table->foreign('customer_name')->references('name')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('depositoris', function(Blueprint $table) {
			$table->foreign('account_number')->references('number')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('loans', function(Blueprint $table) {
			$table->foreign('branch_name')->references('name')->on('branchs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('borrowers', function(Blueprint $table) {
			$table->foreign('customer_name')->references('name')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('borrowers', function(Blueprint $table) {
			$table->foreign('loan_number')->references('number')->on('loans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_branch_name_foreign');
		});
		Schema::table('depositoris', function(Blueprint $table) {
			$table->dropForeign('depositoris_customer_name_foreign');
		});
		Schema::table('depositoris', function(Blueprint $table) {
			$table->dropForeign('depositoris_account_number_foreign');
		});
		Schema::table('loans', function(Blueprint $table) {
			$table->dropForeign('loans_branch_name_foreign');
		});
		Schema::table('borrowers', function(Blueprint $table) {
			$table->dropForeign('borrowers_customer_name_foreign');
		});
		Schema::table('borrowers', function(Blueprint $table) {
			$table->dropForeign('borrowers_loan_number_foreign');
		});
	}
}