<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    public function department()
    {
        return $this->belongsTo('App\DepartementFrancais', 'departementsFrancaises_id');
    }

    public function user()
    {
        return $this->hasOne('App\User');
    }

    public function contrat()
    {
        return $this->hasMany('App\Contrat');
    }

    public function produitsActifs()
    {
        return $this->hasMany('App\ProduitActifClient');
    }

}