<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVideosTable extends Migration {

	public function up()
	{
		Schema::create('videos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('titre', 100);
			$table->text('description')->nullable();
			$table->text('codeInsertion');
			$table->enum('type', array('installation', 'utilisation'));
			$table->integer('id_employe')->unsigned();
			$table->integer('id_produit')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('videos');
	}
}