<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('conversations', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('conversation_id')->references('id')->on('conversations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('conversation_user', function(Blueprint $table) {
			$table->foreign('conversation_id')->references('id')->on('conversations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('conversation_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('conversations', function(Blueprint $table) {
			$table->dropForeign('conversations_job_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_conversation_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_user_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_user_id_foreign');
		});
		Schema::table('conversation_user', function(Blueprint $table) {
			$table->dropForeign('conversation_user_conversation_id_foreign');
		});
		Schema::table('conversation_user', function(Blueprint $table) {
			$table->dropForeign('conversation_user_user_id_foreign');
		});
	}
}