<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('password');
	protected $hidden = array('password');

	public function contents()
	{
		return $this->morphToMany('Content', 'contentable');
	}

	public function user_capabillty()
	{
		return $this->hasMany('Role');
	}

}