<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_roles')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('organizations', function(Blueprint $table) {
			$table->foreign('id_parent')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_organizations', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_organizations', function(Blueprint $table) {
			$table->foreign('id_org')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_organizations', function(Blueprint $table) {
			$table->foreign('id_role')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orgs_roles', function(Blueprint $table) {
			$table->foreign('id_org')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orgs_roles', function(Blueprint $table) {
			$table->foreign('id_role')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coas_of_orgs', function(Blueprint $table) {
			$table->foreign('id_org')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coas_of_orgs', function(Blueprint $table) {
			$table->foreign('id_head_account')->references('id')->on('head_of_accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coas_of_orgs', function(Blueprint $table) {
			$table->foreign('id_parent_with_org')->references('id_with_org')->on('coas_of_orgs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coas_of_orgs', function(Blueprint $table) {
			$table->foreign('id_coa_category')->references('id')->on('coa_category_defaults')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->foreign('id_trs_with_org')->references('id_with_org')->on('transactions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->foreign('id_coa_with_org')->references('id_with_org')->on('coas_of_orgs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->foreign('id_org')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('id_org')->references('id')->on('organizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coa_category_defaults', function(Blueprint $table) {
			$table->foreign('id_head_account')->references('id')->on('head_of_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programs_coas', function(Blueprint $table) {
			$table->foreign('id_program_with_org')->references('id_with_org')->on('programs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('programs_coas', function(Blueprint $table) {
			$table->foreign('id_trs_type')->references('id')->on('transactions_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programs_coas', function(Blueprint $table) {
			$table->foreign('id_coa_with_org')->references('id_with_org')->on('coas_of_orgs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->foreign('id_org')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('id_org')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('id_contacts_types')->references('id')->on('contacts_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('id_contacts')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts_coas', function(Blueprint $table) {
			$table->foreign('id_contacts')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts_coas', function(Blueprint $table) {
			$table->foreign('id_coa_with_org')->references('id_with_org')->on('coas_of_orgs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('programs_transactions', function(Blueprint $table) {
			$table->foreign('id_program_with_org')->references('id_with_org')->on('programs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('programs_transactions', function(Blueprint $table) {
			$table->foreign('id_transactions')->references('id')->on('transactions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('programs_transactions', function(Blueprint $table) {
			$table->foreign('id_coa_with_org_choose')->references('id_with_org')->on('coas_of_orgs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contacts_transactions', function(Blueprint $table) {
			$table->foreign('id_contacts')->references('id')->on('contacts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contacts_transactions', function(Blueprint $table) {
			$table->foreign('id_transactions')->references('id')->on('transactions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('biaya_transactions', function(Blueprint $table) {
			$table->foreign('id_transactions')->references('id')->on('transactions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('biaya_transactions', function(Blueprint $table) {
			$table->foreign('id_coa_with_org')->references('id_with_org')->on('coas_of_orgs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('biaya_transactions', function(Blueprint $table) {
			$table->foreign('id_coa_with_org_bayar_dari')->references('id_with_org')->on('coas_of_orgs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coa_defaults', function(Blueprint $table) {
			$table->foreign('id_head_account')->references('id')->on('head_of_accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coa_defaults', function(Blueprint $table) {
			$table->foreign('id_parent')->references('id')->on('coa_defaults')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('kas_bank_transactions', function(Blueprint $table) {
			$table->foreign('id_transactions')->references('id')->on('transactions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('kas_bank_transactions', function(Blueprint $table) {
			$table->foreign('id_coa_with_org_top')->references('id_with_org')->on('coas_of_orgs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('kas_bank_transactions', function(Blueprint $table) {
			$table->foreign('id_coa_with_org_bottom')->references('id')->on('coas_of_orgs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_roles_foreign');
		});
		Schema::table('organizations', function(Blueprint $table) {
			$table->dropForeign('organizations_id_parent_foreign');
		});
		Schema::table('user_organizations', function(Blueprint $table) {
			$table->dropForeign('user_organizations_id_user_foreign');
		});
		Schema::table('user_organizations', function(Blueprint $table) {
			$table->dropForeign('user_organizations_id_org_foreign');
		});
		Schema::table('user_organizations', function(Blueprint $table) {
			$table->dropForeign('user_organizations_id_role_foreign');
		});
		Schema::table('orgs_roles', function(Blueprint $table) {
			$table->dropForeign('orgs_roles_id_org_foreign');
		});
		Schema::table('orgs_roles', function(Blueprint $table) {
			$table->dropForeign('orgs_roles_id_role_foreign');
		});
		Schema::table('coas_of_orgs', function(Blueprint $table) {
			$table->dropForeign('coas_of_orgs_id_org_foreign');
		});
		Schema::table('coas_of_orgs', function(Blueprint $table) {
			$table->dropForeign('coas_of_orgs_id_head_account_foreign');
		});
		Schema::table('coas_of_orgs', function(Blueprint $table) {
			$table->dropForeign('coas_of_orgs_id_parent_with_org_foreign');
		});
		Schema::table('coas_of_orgs', function(Blueprint $table) {
			$table->dropForeign('coas_of_orgs_id_coa_category_foreign');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->dropForeign('item_transactions_id_trs_with_org_foreign');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->dropForeign('item_transactions_id_coa_with_org_foreign');
		});
		Schema::table('item_transactions', function(Blueprint $table) {
			$table->dropForeign('item_transactions_id_org_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_id_org_foreign');
		});
		Schema::table('coa_category_defaults', function(Blueprint $table) {
			$table->dropForeign('coa_category_defaults_id_head_account_foreign');
		});
		Schema::table('programs_coas', function(Blueprint $table) {
			$table->dropForeign('programs_coas_id_program_with_org_foreign');
		});
		Schema::table('programs_coas', function(Blueprint $table) {
			$table->dropForeign('programs_coas_id_trs_type_foreign');
		});
		Schema::table('programs_coas', function(Blueprint $table) {
			$table->dropForeign('programs_coas_id_coa_with_org_foreign');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->dropForeign('programs_id_org_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_id_org_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_id_contacts_types_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_id_contacts_foreign');
		});
		Schema::table('contacts_coas', function(Blueprint $table) {
			$table->dropForeign('contacts_coas_id_contacts_foreign');
		});
		Schema::table('contacts_coas', function(Blueprint $table) {
			$table->dropForeign('contacts_coas_id_coa_with_org_foreign');
		});
		Schema::table('programs_transactions', function(Blueprint $table) {
			$table->dropForeign('programs_transactions_id_program_with_org_foreign');
		});
		Schema::table('programs_transactions', function(Blueprint $table) {
			$table->dropForeign('programs_transactions_id_transactions_foreign');
		});
		Schema::table('programs_transactions', function(Blueprint $table) {
			$table->dropForeign('programs_transactions_id_coa_with_org_choose_foreign');
		});
		Schema::table('contacts_transactions', function(Blueprint $table) {
			$table->dropForeign('contacts_transactions_id_contacts_foreign');
		});
		Schema::table('contacts_transactions', function(Blueprint $table) {
			$table->dropForeign('contacts_transactions_id_transactions_foreign');
		});
		Schema::table('biaya_transactions', function(Blueprint $table) {
			$table->dropForeign('biaya_transactions_id_transactions_foreign');
		});
		Schema::table('biaya_transactions', function(Blueprint $table) {
			$table->dropForeign('biaya_transactions_id_coa_with_org_foreign');
		});
		Schema::table('biaya_transactions', function(Blueprint $table) {
			$table->dropForeign('biaya_transactions_id_coa_with_org_bayar_dari_foreign');
		});
		Schema::table('coa_defaults', function(Blueprint $table) {
			$table->dropForeign('coa_defaults_id_head_account_foreign');
		});
		Schema::table('coa_defaults', function(Blueprint $table) {
			$table->dropForeign('coa_defaults_id_parent_foreign');
		});
		Schema::table('kas_bank_transactions', function(Blueprint $table) {
			$table->dropForeign('kas_bank_transactions_id_transactions_foreign');
		});
		Schema::table('kas_bank_transactions', function(Blueprint $table) {
			$table->dropForeign('kas_bank_transactions_id_coa_with_org_top_foreign');
		});
		Schema::table('kas_bank_transactions', function(Blueprint $table) {
			$table->dropForeign('kas_bank_transactions_id_coa_with_org_bottom_foreign');
		});
	}
}