<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Vehicle', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Vehicle', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('Brand')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Vehicle', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vehiclefeature', function(Blueprint $table) {
			$table->foreign('vehicle_id')->references('id')->on('Vehicle')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vehiclefeature', function(Blueprint $table) {
			$table->foreign('feature_id')->references('id')->on('Feature')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('Vehicle', function(Blueprint $table) {
			$table->dropForeign('Vehicle_user_id_foreign');
		});
		Schema::table('Vehicle', function(Blueprint $table) {
			$table->dropForeign('Vehicle_brand_id_foreign');
		});
		Schema::table('Vehicle', function(Blueprint $table) {
			$table->dropForeign('Vehicle_category_id_foreign');
		});
		Schema::table('vehiclefeature', function(Blueprint $table) {
			$table->dropForeign('vehiclefeature_vehicle_id_foreign');
		});
		Schema::table('vehiclefeature', function(Blueprint $table) {
			$table->dropForeign('vehiclefeature_feature_id_foreign');
		});
	}
}