<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Chapter extends Model 
{

    protected $table = 'gooddreamer_novel_chapter';
    public $timestamps = false;
    protected $fillable = array('id', 'novel_id', 'chapter_title', 'chapter_content', 'active', 'status', 'created_at', 'updated_at', 'deleted_at', 'published_at');
    protected $visible = array('id', 'novel_id', 'chapter_title', 'chapter_content', 'active', 'status', 'created_at', 'updated_at', 'deleted_at', 'published_at');

    public function novel()
    {
        return $this->belongsTo('Novel');
    }

    public function rewardItem()
    {
        return $this->hasMany('RewardItem');
    }

    public function chapter_progression()
    {
        return $this->hasMany('ChapterProgression', 'chapter_id');
    }

}