<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerAuthorTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_author', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->integer('admin_id')->unique()->unsigned();
			$table->string('uuid', 255);
			$table->string('author_name', 255);
			$table->tinyInteger('status')->default('1');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_author');
	}
}