<?php

class BonusCoin extends Eloquent {

	protected $table = 'gooddreamer_bonus_coin';
	public $timestamps = false;
	protected $fillable = array('id', 'sender_id', 'reward_item_id', 'bonus_type', 'transaction_status', 'transaction_coin_value', 'created_at', 'updated_at');
	protected $visible = array('id', 'sender_id', 'reward_item_id', 'bonus_type', 'transaction_status', 'transaction_coin_value', 'created_at', 'updated_at');

	public function sender()
	{
		return $this->belongsTo('User', 'sender_id');
	}

	public function receiver()
	{
		return $this->belongsTo('User', 'receiver_id');
	}

	public function walletItem()
	{
		return $this->morphOne('WalletItem', 'reffable');
	}

	public function rewardItem()
	{
		return $this->belongsTo('RewardItem', 'reward_item_id');
	}

}