<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerUserDataTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_user_data', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->string('uuid', 255);
			$table->string('user_uri', 255);
			$table->string('fullname', 255);
			$table->string('email', 255);
			$table->string('country_code', 255);
			$table->string('phone', 255)->nullable();
			$table->tinyInteger('gender')->nullable();
			$table->string('username', 255)->nullable();
			$table->date('dob');
			$table->integer('age');
			$table->string('photo_profile_path', 255)->nullable();
			$table->string('photo_profile_filename')->nullable();
			$table->boolean('is_guest')->default(1);
			$table->string('password', 255);
			$table->string('otp_pass', 255)->nullable();
			$table->datetime('otp_valid_until')->nullable();
			$table->string('personal_bio', 255)->nullable();
			$table->string('apns_token', 255)->nullable();
			$table->string('fcm_token', 255)->nullable();
			$table->string('google_token', 255)->nullable();
			$table->string('device_token')->nullable();
			$table->string('email_verif_token', 255)->nullable();
			$table->string('email_verif_expire', 255)->nullable();
			$table->datetime('last_email_verif_date')->nullable();
			$table->tinyInteger('active')->default('1');
			$table->string('referral_code', 255)->nullable();
			$table->datetime('created_at');
			$table->datetime('updated_at')->nullable();
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_user_data');
	}
}