<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('commands', function(Blueprint $table) {
			$table->foreign('id_contract')->references('id')->on('Contrats')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Operations', function(Blueprint $table) {
			$table->foreign('command_id')->references('id')->on('commands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Operations', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('Teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Operations', function(Blueprint $table) {
			$table->foreign('secture_id')->references('id')->on('secteures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sous_operations', function(Blueprint $table) {
			$table->foreign('opertaion_id')->references('id')->on('Operations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Workers', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('Teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Workers', function(Blueprint $table) {
			$table->foreign('type_poste_id')->references('id')->on('Type_Poste')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Produits', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Produits_categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sous_operation_produits', function(Blueprint $table) {
			$table->foreign('id_produit')->references('id')->on('Produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sous_operation_produits', function(Blueprint $table) {
			$table->foreign('sous_operation_id')->references('id')->on('sous_operations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('StockOperations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('commands', function(Blueprint $table) {
			$table->dropForeign('commands_id_contract_foreign');
		});
		Schema::table('Operations', function(Blueprint $table) {
			$table->dropForeign('Operations_command_id_foreign');
		});
		Schema::table('Operations', function(Blueprint $table) {
			$table->dropForeign('Operations_team_id_foreign');
		});
		Schema::table('Operations', function(Blueprint $table) {
			$table->dropForeign('Operations_secture_id_foreign');
		});
		Schema::table('sous_operations', function(Blueprint $table) {
			$table->dropForeign('sous_operations_opertaion_id_foreign');
		});
		Schema::table('Workers', function(Blueprint $table) {
			$table->dropForeign('Workers_team_id_foreign');
		});
		Schema::table('Workers', function(Blueprint $table) {
			$table->dropForeign('Workers_type_poste_id_foreign');
		});
		Schema::table('Produits', function(Blueprint $table) {
			$table->dropForeign('Produits_category_id_foreign');
		});
		Schema::table('sous_operation_produits', function(Blueprint $table) {
			$table->dropForeign('sous_operation_produits_id_produit_foreign');
		});
		Schema::table('sous_operation_produits', function(Blueprint $table) {
			$table->dropForeign('sous_operation_produits_sous_operation_id_foreign');
		});
		Schema::table('StockOperations', function(Blueprint $table) {
			$table->dropForeign('StockOperations_user_id_foreign');
		});
	}
}