<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_g_permission', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_g_permission', function(Blueprint $table) {
			$table->foreign('general_permission_id')->references('id')->on('general_permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_permission', function(Blueprint $table) {
			$table->foreign('forum_id')->references('id')->on('forums')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_permission', function(Blueprint $table) {
			$table->foreign('forum_permission_id')->references('id')->on('forums_permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('role_g_permission', function(Blueprint $table) {
			$table->dropForeign('role_g_permission_role_id_foreign');
		});
		Schema::table('role_g_permission', function(Blueprint $table) {
			$table->dropForeign('role_g_permission_general_permission_id_foreign');
		});
		Schema::table('forum_permission', function(Blueprint $table) {
			$table->dropForeign('forum_permission_forum_id_foreign');
		});
		Schema::table('forum_permission', function(Blueprint $table) {
			$table->dropForeign('forum_permission_forum_permission_id_foreign');
		});
	}
}