<?php

namespace POP;

class Pops extends Eloquent {

	protected $table = 'pops';
	public $timestamps = true;

	public function pop()
	{
		return $this->hasOne('PopLocation', 'location_id');
	}

	public function pop()
	{
		return $this->hasMany('PopBackhaulBwCapacity', 'backhaul_bw_capacity_id');
	}

	public function pop()
	{
		return $this->hasMany('PopBackhaulProvider', 'backhaulprovider_id');
	}

	public function pop()
	{
		return $this->hasOne('PopTypeOfEquipment', 'typeofequipment_id');
	}

	public function pop()
	{
		return $this->hasOne('PopEquipmentVendor', 'equipmentvendor_id');
	}

	public function pop()
	{
		return $this->hasOne('PopDataCenter', 'datacenter_id');
	}

	public function pop()
	{
		return $this->hasMany('PopAend', 'a_end_id');
	}

	public function pop()
	{
		return $this->hasMany('PopBEnd', 'b_end_id');
	}

}