<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('unit', 191);
			$table->integer('barcode');
			$table->decimal('first_balance');
			$table->decimal('price');
			$table->bigInteger('stock_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}