<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTravelsTable extends Migration {

	public function up()
	{
		Schema::create('travels', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('number');
			$table->date('date');
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('car_id')->unsigned();
			$table->bigInteger('driver_id')->unsigned();
			$table->string('place_do', 191);
			$table->string('Arrival', 191);
			$table->decimal('payload_w');
			$table->string('unit', 191);
			$table->decimal('cost');
			$table->bigInteger('pricing_type')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('travels');
	}
}