<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('drivers', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('stock_id')->references('id')->on('stocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('travels', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('travels', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('travels', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->foreign('stock_id')->references('id')->on('stocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->foreign('travel_id')->references('id')->on('travels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('safe_id')->references('id')->on('safes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advances', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advances', function(Blueprint $table) {
			$table->foreign('t_advance_id')->references('id')->on('t_advances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('custodys', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('custodys', function(Blueprint $table) {
			$table->foreign('t_custody_id')->references('id')->on('t_custodys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_banks', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_supplier_id_foreign');
		});
		Schema::table('drivers', function(Blueprint $table) {
			$table->dropForeign('drivers_supplier_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_stock_id_foreign');
		});
		Schema::table('travels', function(Blueprint $table) {
			$table->dropForeign('travels_customer_id_foreign');
		});
		Schema::table('travels', function(Blueprint $table) {
			$table->dropForeign('travels_car_id_foreign');
		});
		Schema::table('travels', function(Blueprint $table) {
			$table->dropForeign('travels_driver_id_foreign');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->dropForeign('t_products_product_id_foreign');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->dropForeign('t_products_stock_id_foreign');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->dropForeign('t_products_travel_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_safe_id_foreign');
		});
		Schema::table('advances', function(Blueprint $table) {
			$table->dropForeign('advances_driver_id_foreign');
		});
		Schema::table('advances', function(Blueprint $table) {
			$table->dropForeign('advances_t_advance_id_foreign');
		});
		Schema::table('custodys', function(Blueprint $table) {
			$table->dropForeign('custodys_driver_id_foreign');
		});
		Schema::table('custodys', function(Blueprint $table) {
			$table->dropForeign('custodys_t_custody_id_foreign');
		});
		Schema::table('t_banks', function(Blueprint $table) {
			$table->dropForeign('t_banks_bank_id_foreign');
		});
	}
}