<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarsTable extends Migration {

	public function up()
	{
		Schema::create('cars', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('type', 191);
			$table->integer('license_num');
			$table->integer('model');
			$table->integer('car_num');
			$table->integer('driver_num');
			$table->decimal('payload');
			$table->decimal('car_weight');
			$table->bigInteger('supplier_id')->unsigned();
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('cars');
	}
}