<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nom', 150);
			$table->text('body');
			$table->date('date');
			$table->time('heure');
			$table->string('prix', 10);
			$table->string('adresse', 255);
			$table->string('long', 255)->nullable();
			$table->string('alti', 255)->nullable();
			$table->string('image', 255);
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}