<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Thread extends Model 
{

    protected $table = 'threads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function posts()
    {
        return $this->hasMany('Post');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function channel()
    {
        return $this->belongsTo('Channel');
    }

    public function notifications()
    {
        return $this->hasMany('Notification');
    }

}