<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->string('name', 150);
			$table->string('rfc', 13)->nullable();
			$table->string('street', 200)->nullable();
			$table->string('ext_num', 10)->nullable();
			$table->string('int_num', 10)->nullable();
			$table->string('city', 100)->nullable();
			$table->bigInteger('state_id')->unsigned()->nullable();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->string('zip', 7)->nullable();
			$table->string('phone', 10)->nullable();
			$table->string('contact_name', 100)->nullable();
			$table->string('contact_last_name', 100)->nullable();
			$table->string('email_contacto', 100)->nullable();
			$table->integer('telefono_contacto')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}