<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFranchiseesTable extends Migration {

	public function up()
	{
		Schema::create('franchisees', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->string('name', 250);
			$table->string('rfc', 13);
			$table->string('street', 200)->nullable();
			$table->string('ext_num', 10)->nullable();
			$table->string('int_num', 10)->nullable();
			$table->string('city', 100)->nullable();
			$table->bigInteger('state_id')->unsigned();
			$table->bigInteger('country_id')->unsigned();
			$table->string('zip', 7);
			$table->string('phone', 10)->nullable();
			$table->string('contact_name', 100)->nullable();
			$table->string('contact_last_name', 100)->nullable();
			$table->string('contact_email', 100)->nullable();
			$table->string('contact_phone', 10)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('franchisees');
	}
}