<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupplyHistoryTable extends Migration {

	public function up()
	{
		Schema::create('supply_history', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('station_id')->unsigned();
			$table->bigInteger('supply_type_id')->unsigned();
			$table->decimal('quantity', 11,2);
			$table->bigInteger('washed_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('supply_history');
	}
}