<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUploadsTable extends Migration {

	public function up()
	{
		Schema::create('uploads', function(Blueprint $table) {
			$table->increments('upload_id');
			$table->integer('upload_user_id')->index();
			$table->string('upload_file_type', 50);
			$table->string('upload_file_size', 50);
			$table->string('upload_file_name', 100);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('uploads');
	}
}