<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('post_id');
			$table->string('post_title', 100)->index();
			$table->integer('post_user_id');
			$table->text('post_description')->index();
			$table->string('post_meta_keyword', 200)->index();
			$table->text('post_meta_description')->index();
			$table->integer('post_upload_id');
			$table->integer('post_collection_id');
			$table->integer('post_category_id');
			$table->integer('post_cover_photo_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}