<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('models', function(Blueprint $table) {
			$table->foreign('category')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('models', function(Blueprint $table) {
			$table->foreign('maker')->references('id')->on('makers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('roles')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_prefs', function(Blueprint $table) {
			$table->foreign('languaje')->references('id')->on('languajes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_prefs', function(Blueprint $table) {
			$table->foreign('user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_prefs', function(Blueprint $table) {
			$table->foreign('volume')->references('id')->on('units_vol')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_prefs', function(Blueprint $table) {
			$table->foreign('distance')->references('id')->on('units_dist')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('category')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('maker')->references('id')->on('makers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('model')->references('id')->on('models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('records', function(Blueprint $table) {
			$table->foreign('vehicles')->references('id')->on('vehicles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('records', function(Blueprint $table) {
			$table->foreign('expen_type')->references('id')->on('expenditures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('models', function(Blueprint $table) {
			$table->dropForeign('models_category_foreign');
		});
		Schema::table('models', function(Blueprint $table) {
			$table->dropForeign('models_maker_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_roles_foreign');
		});
		Schema::table('user_prefs', function(Blueprint $table) {
			$table->dropForeign('user_prefs_languaje_foreign');
		});
		Schema::table('user_prefs', function(Blueprint $table) {
			$table->dropForeign('user_prefs_user_foreign');
		});
		Schema::table('user_prefs', function(Blueprint $table) {
			$table->dropForeign('user_prefs_volume_foreign');
		});
		Schema::table('user_prefs', function(Blueprint $table) {
			$table->dropForeign('user_prefs_distance_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_user_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_category_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_maker_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_model_foreign');
		});
		Schema::table('records', function(Blueprint $table) {
			$table->dropForeign('records_vehicles_foreign');
		});
		Schema::table('records', function(Blueprint $table) {
			$table->dropForeign('records_expen_type_foreign');
		});
	}
}