<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderCatalogTable extends Migration {

	public function up()
	{
		Schema::create('order_catalog', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('store_catalog_id')->unsigned();
			$table->integer('price')->unsigned();
			$table->integer('quantity')->unsigned();
			$table->text('note');
			$table->enum('driver_status', array('open', 'done', 'denied'));
		});
	}

	public function down()
	{
		Schema::drop('order_catalog');
	}
}