<?php

namespace doctor;

class Doctor extends Eloquent {

	protected $table = 'doctor';
	public $timestamps = true;

	public function doctorSpecialties()
	{
		return $this->hasMany('DoctorSpecialty');
	}

	public function DoctorCertificates()
	{
		return $this->hasMany('DoctorCertificates');
	}

	public function WorkingHours()
	{
		return $this->hasMany('DoctorWorkingHours');
	}

	public function bankAccounts()
	{
		return $this->hasMany('DoctorBankAccounts');
	}

	public function insuranceCompany()
	{
		return $this->hasMany('DoctorInsuranceCompany');
	}

	public function doctorWorkplaces()
	{
		return $this->hasMany('DoctorPlaceOfWork');
	}

	public function doctorConsultationInfo()
	{
		return $this->hasMany('DoctorConsultationInfo');
	}

	public function DoctorAssistant()
	{
		return $this->hasMany('doctorAssistantInfo\DoctorAssistantInfo');
	}

	public function Booking()
	{
		return $this->hasMany('Booking');
	}

}