<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('user_name')->nullable();
			$table->string('email');
			$table->timestamp('email_verified_at')->nullable();
			$table->integer('phone')->nullable();
			$table->string('password');
			$table->string('image')->nullable();
			$table->string('is_admin')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}