<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('activations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('reminders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parkspots', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parkrequests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('parkrequests', function(Blueprint $table) {
			$table->foreign('parkspot_id')->references('id')->on('parkspots')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('activations', function(Blueprint $table) {
			$table->dropForeign('activations_user_id_foreign');
		});
		Schema::table('reminders', function(Blueprint $table) {
			$table->dropForeign('reminders_user_id_foreign');
		});
		Schema::table('parkspots', function(Blueprint $table) {
			$table->dropForeign('parkspots_user_id_foreign');
		});
		Schema::table('parkrequests', function(Blueprint $table) {
			$table->dropForeign('parkrequests_user_id_foreign');
		});
		Schema::table('parkrequests', function(Blueprint $table) {
			$table->dropForeign('parkrequests_parkspot_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_user_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_by_foreign');
		});
	}
}