<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('mobile');
			$table->enum('type', array('advertisement', 'suggestion', 'inquiry', 'complaint', 'other'));
			$table->string('message');
			$table->string('reply_message')->nullable();
			$table->boolean('is_answered');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}