<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFundHistoryTable extends Migration {

	public function up()
	{
		Schema::create('fund_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('fund_id')->nullable();
			$table->integer('fund_account_id')->nullable();
			$table->double('credit')->nullable();
			$table->double('debit')->nullable();
			$table->string('type')->nullable();
			$table->double('balance')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fund_history');
	}
}