<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Fund extends Eloquent {

	protected $table = 'fund';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'active');

	public function fund_accounts()
	{
		return $this->hasMany('FundAccount', 'fund_id');
	}

}