<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InvoiceItem extends Eloquent {

	protected $table = 'invoice_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('invoice_id', 'details', 'quantity', 'price', 'total');

	public function invoice()
	{
		return $this->belongsTo('Invoice', 'invoice_id');
	}

}