<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoiceItem extends Model 
{

    protected $table = 'invoice_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('invoice_id', 'details', 'quantity', 'price', 'total');

    public function invoice()
    {
        return $this->belongsTo('Invoice', 'invoice_id');
    }

}