<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code')->nullable();
			$table->string('type');
			$table->enum('amount_type', array('fixed', 'percentage'));
			$table->double('amount');
			$table->timestamp('from');
			$table->timestamp('to');
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}