<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductOffersTable extends Migration {

	public function up()
	{
		Schema::create('product_offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('product_id')->unsigned();
			$table->datetime('day_start');
			$table->datetime('day_end');
			$table->double('percentage', 2,2);
			$table->double('price')->default('0');
			$table->integer('quantity')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('product_offers');
	}
}