<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->softDeletes();
			$table->string('key');
			$table->text('value');
			$table->boolean('status')->default(0);
			$table->string('name')->nullable();
			$table->integer('setting_group_id')->unsigned();
			$table->enum('type', array('string', 'number', 'text', 'file'));
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}