<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('status', array('new', 'in_process', 'completed', 'canceled'));
			$table->enum('payment_status', array('pending', 'paid', 'not_paid'));
			$table->string('name', 255)->nullable();
			$table->integer('person_quantity')->default('1');
			$table->integer('people_for_quantity')->default('1');
			$table->boolean('is_takeaway')->default(0);
			$table->boolean('is_online_payment')->default(0);
			$table->bigInteger('restaurant_id')->unsigned();
			$table->bigInteger('client_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}