<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('carts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('carts_products', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('carts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('carts_products', function(Blueprint $table) {
			$table->foreign('product_info_id')->references('id')->on('carts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_discounts', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('orders_discounts', function(Blueprint $table) {
			$table->foreign('discount_id')->references('id')->on('discounts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_cart_id_foreign');
		});
		Schema::table('carts_products', function(Blueprint $table) {
			$table->dropForeign('carts_products_cart_id_foreign');
		});
		Schema::table('carts_products', function(Blueprint $table) {
			$table->dropForeign('carts_products_product_info_id_foreign');
		});
		Schema::table('orders_discounts', function(Blueprint $table) {
			$table->dropForeign('orders_discounts_order_id_foreign');
		});
		Schema::table('orders_discounts', function(Blueprint $table) {
			$table->dropForeign('orders_discounts_discount_id_foreign');
		});
	}
}