<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Articles', function(Blueprint $table) {
			$table->foreign('providerlist_id')->references('id')->on('ProviderList')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('x_Articles_Providers', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('Providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('x_Articles_Providers', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('Providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ProviderList', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('Providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Articles', function(Blueprint $table) {
			$table->dropForeign('Articles_providerlist_id_foreign');
		});
		Schema::table('x_Articles_Providers', function(Blueprint $table) {
			$table->dropForeign('x_Articles_Providers_provider_id_foreign');
		});
		Schema::table('x_Articles_Providers', function(Blueprint $table) {
			$table->dropForeign('x_Articles_Providers_article_id_foreign');
		});
		Schema::table('ProviderList', function(Blueprint $table) {
			$table->dropForeign('ProviderList_provider_id_foreign');
		});
	}
}