<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostulanteTable extends Migration {

	public function up()
	{
		Schema::create('postulante', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('id_postulante', 255);
			$table->string('nombre', 255);
			$table->string('apellido', 255);
			$table->string('direccion', 255);
			$table->datetime('fechaNacimiento');
			$table->integer('id_corregimiento');
			$table->string('email', 255);
			$table->integer('id_tipoIndentidad');
			$table->string('curriculum', 255);
			$table->enum('estado', array('EnEspera', 'EnEvaluacion', 'EsperandoAprobacion', 'Aceptado', 'Rechazado', 'Retirado'));
		});
	}

	public function down()
	{
		Schema::drop('postulante');
	}
}