<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('lastname', 255);
			$table->string('firstname', 255);
			$table->string('email');
			$table->string('link');
			$table->boolean('status')->default(0);
			$table->date('dob');
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}