<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormationsTable extends Migration {

	public function up()
	{
		Schema::create('Formations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('filiale_id')->unsigned();
			$table->string('intitule_formation');
			$table->date('date_formation');
			$table->integer('duree_formation');
			$table->integer('eff_a_former_mait');
			$table->integer('eff_a_former_cad');
			$table->integer('eff_a_former_exec');
			$table->integer('eff_forme_mait');
			$table->integer('eff_forme_cad');
			$table->integer('eff_forme_exec');
			$table->float('budget_prevu');
			$table->float('budget_real');
			$table->integer('organisme_id')->unsigned();
			$table->boolean('valide');
		});
	}

	public function down()
	{
		Schema::drop('Formations');
	}
}