<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlightPricesTable extends Migration {

	public function up()
	{
		Schema::create('flight_prices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('seat_id');
			$table->integer('flight_type_id');
			$table->integer('age_id');
			$table->double('price');
			$table->integer('duration_id')->nullable();
			$table->integer('flight_id');
		});
	}

	public function down()
	{
		Schema::drop('flight_prices');
	}
}