<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id');
			$table->integer('item_id');
			$table->enum('status', array('download', 'confirmed', 'cancelled', 'void', 'temporary', 'noshow', 'used'));
			$table->integer('user_id');
			$table->string('phone');
			$table->string('pnr');
			$table->double('total_price');
			$table->double('commission');
			$table->double('subtotal');
			$table->string('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}