<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('m_kegiatan', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('m_program')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('m_output', function(Blueprint $table) {
			$table->foreign('kegiatan_id')->references('id')->on('m_kegiatan')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('t_pagu', function(Blueprint $table) {
			$table->foreign('kegiatan_id')->references('id')->on('m_kegiatan')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_pagu', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('m_unit')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_realisasi', function(Blueprint $table) {
			$table->foreign('kegiatan_id')->references('id')->on('m_kegiatan')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_realisasi', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('m_unit')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_rpa', function(Blueprint $table) {
			$table->foreign('kegiatan_id')->references('id')->on('m_kegiatan')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_rpa', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('m_unit')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('m_unit', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('m_unit')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('m_kegiatan', function(Blueprint $table) {
			$table->dropForeign('m_kegiatan_program_id_foreign');
		});
		Schema::table('m_output', function(Blueprint $table) {
			$table->dropForeign('m_output_kegiatan_id_foreign');
		});
		Schema::table('t_pagu', function(Blueprint $table) {
			$table->dropForeign('t_pagu_kegiatan_id_foreign');
		});
		Schema::table('t_pagu', function(Blueprint $table) {
			$table->dropForeign('t_pagu_unit_id_foreign');
		});
		Schema::table('t_realisasi', function(Blueprint $table) {
			$table->dropForeign('t_realisasi_kegiatan_id_foreign');
		});
		Schema::table('t_realisasi', function(Blueprint $table) {
			$table->dropForeign('t_realisasi_unit_id_foreign');
		});
		Schema::table('t_rpa', function(Blueprint $table) {
			$table->dropForeign('t_rpa_kegiatan_id_foreign');
		});
		Schema::table('t_rpa', function(Blueprint $table) {
			$table->dropForeign('t_rpa_unit_id_foreign');
		});
		Schema::table('m_unit', function(Blueprint $table) {
			$table->dropForeign('m_unit_parent_id_foreign');
		});
	}
}