<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAbModulesTable extends Migration {

	public function up()
	{
		Schema::create('ab_modules', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('program_id')->unsigned()->index();
			$table->integer('week')->unsigned();
			$table->text('title');
			$table->text('recommended')->nullable();
			$table->text('instructions');
			$table->text('video_url')->nullable();
			$table->text('thumbnail')->nullable();
			$table->boolean('observe_cheat_day');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ab_modules');
	}
}